# Rich Animals Telegram Bot

A simple Telegram bot game where users can collect daily rewards and compete with others.

## Setup Instructions

1. Clone this repository to your web server
2. Create a new database:
   ```sql
   CREATE DATABASE rich_animals_bot;
   ```
3. Import the database structure:
   ```sql
   SOURCE mysql.sql;
   ```
4. Configure your bot:
   - Open `config.php`
   - Replace `YOUR_BOT_TOKEN_HERE` with your actual bot token from BotFather
   - Update the `WEBHOOK_URL` with your actual domain
5. Set up webhook:
   ```bash
   curl -F "url=https://your-domain.com/rich-animals-bot/webhook.php" \
        "https://api.telegram.org/botYOUR_BOT_TOKEN/setWebhook"
   ```

## Features

- Daily reward system
- User balance tracking
- Simple command interface
- MySQL database integration

## Commands

- `/start` - Start the bot and get help
- `/balance` - Check your current balance
- `/claim` - Claim your daily reward

## Requirements

- PHP 7.4 or higher
- MySQL 5.7 or higher
- cURL extension
- JSON extension
