<?php
// === CONFIG ===
$bot_token = "8103587410:AAEllA5-HO60fgWTrnrFD8yMqTm-fHURtA8";
$gemini_api_key = "AIzaSyDe7CBsjQ9JQQviore04QXF8w1RhAS3clQ";
$users_file = "users.json";

// === Get update ===
$update = json_decode(file_get_contents("php://input"), true);
$message = $update["message"] ?? null;
$chat_id = $message["chat"]["id"] ?? null;
$text = $message["text"] ?? '';
$user_id = $message["from"]["id"] ?? 0;

// === Load or create user DB ===
$users = file_exists($users_file) ? json_decode(file_get_contents($users_file), true) : [];

// === Helper Functions ===
function sendMessage($chat_id, $text, $keyboard = null) {
    global $bot_token;
    $payload = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    if ($keyboard) $payload['reply_markup'] = json_encode(['keyboard' => $keyboard, 'resize_keyboard' => true]);
    file_get_contents("https://api.telegram.org/bot$bot_token/sendMessage?" . http_build_query($payload));
}

function geminiReply($prompt) {
    global $gemini_api_key;
    $url = "https://generativelanguage.googleapis.com/v1beta/models/gemini-pro:generateContent?key=$gemini_api_key";
    $post = [
        "contents" => [[ "parts" => [[ "text" => $prompt ]]]]
    ];
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($post),
        CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        CURLOPT_RETURNTRANSFER => true
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
    $data = json_decode($response, true);
    return $data['candidates'][0]['content']['parts'][0]['text'] ?? "🤖 Gemini is thinking...";
}

function saveUsers($users) {
    global $users_file;
    file_put_contents($users_file, json_encode($users));
}

// === Commands ===
if ($text == "/start") {
    $users[$user_id] = [
        "chat_id" => $chat_id,
        "status" => "idle",
        "partner" => null,
        "gender" => rand(0,1) ? "male" : "female",
        "with_gemini" => false
    ];
    sendMessage($chat_id, "👋 Welcome to Random Chat!\nPress '🔍 Find Partner' to connect.", [["🔍 Find Partner"]]);
    saveUsers($users);
    exit;
}

if ($text == "🔍 Find Partner") {
    $users[$user_id]["status"] = "searching";
    $users[$user_id]["partner"] = null;
    $users[$user_id]["with_gemini"] = false;

    $found = false;
    foreach ($users as $uid => $u) {
        if ($uid != $user_id && $u["status"] == "searching" && $u["gender"] != $users[$user_id]["gender"]) {
            // Match found
            $users[$user_id]["partner"] = $uid;
            $users[$uid]["partner"] = $user_id;
            $users[$user_id]["status"] = "chatting";
            $users[$uid]["status"] = "chatting";
            sendMessage($users[$user_id]["chat_id"], "✅ You’re connected! Start chatting.");
            sendMessage($users[$uid]["chat_id"], "✅ You’re connected! Start chatting.");
            $found = true;
            break;
        }
    }

    if (!$found) {
        // No user, connect with Gemini
        $users[$user_id]["status"] = "chatting";
        $users[$user_id]["with_gemini"] = true;
        sendMessage($chat_id, "🤖 No human partner found. You're now chatting with Gemini AI as your anonymous partner.");
    }

    saveUsers($users);
    exit;
}

if ($text == "❌ End Chat" || $text == "/end") {
    if ($users[$user_id]["status"] != "chatting") {
        sendMessage($chat_id, "❌ You're not in an active chat.");
        exit;
    }

    if ($users[$user_id]["with_gemini"]) {
        sendMessage($chat_id, "❌ You have ended the chat with Gemini.");
    } elseif (!empty($users[$user_id]["partner"])) {
        $partner_id = $users[$user_id]["partner"];
        sendMessage($chat_id, "❌ You left the chat.");
        sendMessage($users[$partner_id]["chat_id"], "⚠️ Your partner has left the chat.");
        $users[$partner_id]["status"] = "idle";
        $users[$partner_id]["partner"] = null;
    }

    $users[$user_id]["status"] = "idle";
    $users[$user_id]["partner"] = null;
    $users[$user_id]["with_gemini"] = false;

    saveUsers($users);
    exit;
}

// === Chatting Logic ===
if ($users[$user_id]["status"] == "chatting") {
    if ($users[$user_id]["with_gemini"]) {
        // Talking with Gemini
        $user_gender = $users[$user_id]["gender"];
        $partner_gender = $user_gender == "male" ? "female" : "male";
        $prompt = "You are chatting as a $partner_gender talking to a $user_gender. Be friendly, casual, sometimes flirty like an anonymous random person. Reply to:\n\"$text\"";
        $reply = geminiReply($prompt);
        sendMessage($chat_id, "👤 $partner_gender: $reply");
    } elseif (!empty($users[$user_id]["partner"])) {
        $partner_id = $users[$user_id]["partner"];
        if (isset($users[$partner_id])) {
            sendMessage($users[$partner_id]["chat_id"], "👤 Stranger: $text");
        } else {
            sendMessage($chat_id, "⚠️ Your partner disconnected.");
        }
    } else {
        sendMessage($chat_id, "⚠️ Chat partner not found.");
    }

    saveUsers($users);
    exit;
}

