<?php
/**
 * Telegram Bot Webhook Setup Script
 * Run this script once to set your bot's webhook URL
 */

require_once 'config.php';

// Function to make Telegram API request
function telegramRequest($method, $parameters = []) {
    $url = TELEGRAM_API . $method;
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $parameters);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $response = curl_exec($ch);
    curl_close($ch);
    
    return json_decode($response, true);
}

echo "<h1>Telegram Bot Webhook Setup</h1>";

// Check if bot token is set
if (BOT_TOKEN === 'YOUR_BOT_TOKEN_HERE') {
    echo "<p style='color: red;'><strong>Error:</strong> Please set your bot token in config.php first!</p>";
    exit;
}

// Get bot info
echo "<h2>Bot Information</h2>";
$bot_info = telegramRequest('getMe');

if ($bot_info['ok']) {
    echo "<p><strong>Bot Name:</strong> " . $bot_info['result']['first_name'] . "</p>";
    echo "<p><strong>Bot Username:</strong> @" . $bot_info['result']['username'] . "</p>";
    echo "<p><strong>Bot ID:</strong> " . $bot_info['result']['id'] . "</p>";
} else {
    echo "<p style='color: red;'><strong>Error:</strong> Invalid bot token!</p>";
    exit;
}

// Set webhook
echo "<h2>Setting Webhook</h2>";
echo "<p><strong>Webhook URL:</strong> " . WEBHOOK_URL . "</p>";

$webhook_result = telegramRequest('setWebhook', [
    'url' => WEBHOOK_URL
]);

if ($webhook_result['ok']) {
    echo "<p style='color: green;'><strong>Success:</strong> Webhook set successfully!</p>";
    echo "<p>" . $webhook_result['description'] . "</p>";
} else {
    echo "<p style='color: red;'><strong>Error:</strong> Failed to set webhook!</p>";
    echo "<p>Error: " . $webhook_result['description'] . "</p>";
}

// Get webhook info
echo "<h2>Current Webhook Status</h2>";
$webhook_info = telegramRequest('getWebhookInfo');

if ($webhook_info['ok']) {
    $info = $webhook_info['result'];
    echo "<p><strong>URL:</strong> " . ($info['url'] ?: 'Not set') . "</p>";
    echo "<p><strong>Has Custom Certificate:</strong> " . ($info['has_custom_certificate'] ? 'Yes' : 'No') . "</p>";
    echo "<p><strong>Pending Update Count:</strong> " . $info['pending_update_count'] . "</p>";
    
    if (isset($info['last_error_date'])) {
        echo "<p><strong>Last Error Date:</strong> " . date('Y-m-d H:i:s', $info['last_error_date']) . "</p>";
        echo "<p><strong>Last Error Message:</strong> " . $info['last_error_message'] . "</p>";
    }
    
    if (isset($info['max_connections'])) {
        echo "<p><strong>Max Connections:</strong> " . $info['max_connections'] . "</p>";
    }
} else {
    echo "<p style='color: red;'><strong>Error:</strong> Could not get webhook info!</p>";
}

echo "<h2>Next Steps</h2>";
echo "<ul>";
echo "<li>Make sure your webhook URL is accessible from the internet</li>";
echo "<li>Test your bot by sending /start command</li>";
echo "<li>Check your server error logs if the bot doesn't respond</li>";
echo "<li>Set up your database using db.sql</li>";
echo "<li>Configure your admin IDs in config.php</li>";
echo "</ul>";

echo "<h2>Test Commands</h2>";
echo "<p>Try these commands with your bot:</p>";
echo "<ul>";
echo "<li><code>/start</code> - Start the bot</li>";
echo "<li><code>/help</code> - Show help message</li>";
echo "<li><code>/admin</code> - Access admin panel (admins only)</li>";
echo "</ul>";

// Delete webhook (uncomment if needed)
/*
echo "<h2>Delete Webhook</h2>";
$delete_result = telegramRequest('deleteWebhook');
if ($delete_result['ok']) {
    echo "<p style='color: green;'>Webhook deleted successfully!</p>";
} else {
    echo "<p style='color: red;'>Failed to delete webhook!</p>";
}
*/
?>
